% script for plotting the concentration measurements

clear all, close all

% % chronoamperometry
% % 5 l/min 1 mMNaCl 5M NaAlexa @ 70 V
% c5 = [1.620908424	0.587889244	1.450401348	0.700309778	1.317024005	nan];
% % 3 l/min 1 mMNaCl 5M NaAlexa @ 70 V
% c3 = [2.071210463	0.419980307	1.689493727	0.508924131	1.277991904	0.532529591];
% % transpose, otherwise bar does not give proper results
% c = fliplr([c3; c5])';

% chronopotentiometry
% 3 uA-2
c3 = [nan	1.689493727	0.444391576	1.461529286	0.332503761	1.563233449];
% chip 20 1 mMNaCl 5M NaAlexa @ 5uA
c5 = [0.746244392	1.310928758	0.273581966	1.408949105	0.305156238	1.689493727];
% 7 uA-2
c7 = [nan	1.625106626	0.224164339	1.895347884	0.235605557	1.949975259];
% transpose, otherwise bar does not give proper results
c = [c3; c5; c7]';


% colors
no_exp = size(c,2);
nn = 0;
map = cbrewer('seq','OrRdBlGr',no_exp);

nn = nn + 1;
figure(nn)
hold on
h = plot([0.5 6.5],[1 1],':k');
b = bar(c);
hold off
box on
xlim([0.5 6.5])
ylim([0 2.5])
for j = 1:no_exp
    set(b(j),'FaceColor',map(j,:));
end
set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
%legend('3 \muL/min','5 \muL/min')
legend('3 \muA','5 \muA','7 \muA')
legend('Location','NorthWest')
legend boxoff
%title('(a) Outlet concentrations at \DeltaU = 70V for 1 mM NaCl')
title('(b) Outlet concentrations at 3 \muL min^{-1} for 1 mM NaCl')
xlabel('channel number')
ylabel('c (mM)')
set(gcf,'color','w');
%print('BarPlot','-dpng','-r300')
%export_fig cNaCl_flowrate.png -m3
%export_fig cNaCl_fixedI.png -m3

matlab2tikz('cNaCl_fixedI.tikz', 'height', '\figureheight', 'width', '\figurewidth');